<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| CI Bootstrap 3 Configuration
| -------------------------------------------------------------------------
| This file lets you define default values to be passed into views 
| when calling MY_Controller's render() function. 
| 
| See example and detailed explanation from:
| 	/application/config/ci_bootstrap_example.php
*/

$config['ci_bootstrap'] = array(

	// Site name
	'site_name' => 'Partnership Kinostore',

	// Default page title prefix
	'page_title_prefix' => '',

	// Default page title
	'page_title' => '',

	// Default meta data
	'meta_data'	=> array(
		'author'		=> '',
		'description'	=> '',
		'keywords'		=> ''
	),

	// Default scripts to embed at page head or end
	'scripts' => array(
		'head'	=> array(
		),
		'foot'	=> array(
			'assets/dist/frontend/js/jquery-2.2.4.min.js',
			'assets/dist/frontend/js/bootstrap.min.js',
			'assets/dist/frontend/js/popper.min.js',
			'assets/dist/frontend/js/pace.min.js',
			'assets/dist/frontend/js/back-to-top.js',
			'assets/dist/frontend/js/venobox.min.js',
			'assets/dist/frontend/js/slick/slick.min.js',
			'https://cdn.rawgit.com/michalsnik/aos/2.1.1/dist/aos.js',
			'assets/dist/frontend/js/main.js'
		),
	),

	// Default stylesheets to embed at page head
	'stylesheets' => array(
		'screen' => array(
			'https://fonts.googleapis.com/css?family=Poppins:400,400i,500,500i|Roboto:500,700',
			// 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css',
			'assets/dist/frontend/css/font-awesome.min.css',
			/* 'assets/dist/fontawesome/css/all.css', */
			'assets/dist/frontend/css/bootstrap.min.css',
			'assets/dist/frontend/css/venobox.css',
			'assets/dist/frontend/js/slick/slick.css',
			'assets/dist/frontend/js/slick/slick-theme.css',
			'https://cdn.rawgit.com/michalsnik/aos/2.1.1/dist/aos.css',
			'assets/dist/frontend/css/style.css',
			'assets/dist/frontend/css/components.css'
		)
	),

	// Default CSS class for <body> tag
	'body_class' => 'theme-pearl store-view-default checkout-cart-index page-layout-1column',
	
	// Multilingual settings
/* 	'languages' => array(
		'default'		=> 'en',
		'autoload'		=> array('general'),
		'available'		=> array(
			'en' => array(
				'label'	=> 'English',
				'value'	=> 'english'
			),
			'id' => array(
				'label'	=> 'Indonesia',
				'value'	=> 'indonesia'
			)
		)
	),
 */
	// Google Analytics User ID
	'ga_id' => 'UA-135131458-2',

	// Menu items
	'menu' => array(
		'home' => array(
			'name'		=> 'Home',
			'url'		=> '',
		),
	),

	// Login page
	'login_url' => '',

	// Restricted pages
	'page_auth' => array(
	),

	// Email config
	'email' => array(
		'from_email'		=> 'no-reply@kinostore.co.id',
		'from_name'			=> 'KinoStore',
		'subject_prefix'	=> 'KinoStore',
		
		// Mailgun HTTP API
		'mailgun_api'		=> array(
			'domain'			=> '',
			'private_api_key'	=> ''
		),
	),

	// Debug tools
	'debug' => array(
		'view_data'	=> FALSE,
		'profiler'	=> FALSE
	),
);

/*
| -------------------------------------------------------------------------
| Override values from /application/config/config.php
| -------------------------------------------------------------------------
*/
$config['sess_cookie_name'] = 'ci_session_frontend';