<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| CI Bootstrap 3 Configuration
| -------------------------------------------------------------------------
| This file lets you define default values to be passed into views 
| when calling MY_Controller's render() function. 
| 
| See example and detailed explanation from:
| 	/application/config/ci_bootstrap_example.php
*/

$config['ci_bootstrap'] = array(

	// Site name
	'site_name' => 'Admin Panel',

	// Default page title prefix
	'page_title_prefix' => '',

	// Default page title
	'page_title' => '',

	// Default meta data
	'meta_data'	=> array(
		'author'		=> '',
		'description'	=> '',
		'keywords'		=> ''
	),
	
	// Default scripts to embed at page head or end
	'scripts' => array(
		'head'	=> array(
			// 'https://code.jquery.com/jquery-1.12.4.js',
			// 'https://code.jquery.com/ui/1.12.1/jquery-ui.js',
			'assets/dist/admin/adminlte.min.js',
			'assets/dist/admin/lib.min.js',
			'assets/dist/admin/app.min.js',
			'assets/dist/admin/packages/core/main.js',
			'assets/dist/admin/packages/interaction/main.js',
			'assets/dist/admin/packages/daygrid/main.js',
			'assets/dist/admin/packages/timegrid/main.js',
			'assets/dist/admin/js/bootstrap-datetimepicker.js',
			'assets/dist/admin/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js',
			'assets/dist/admin/packages/list/main.js',
			// 'assets/dist/admin/moment/moment.js',
			// 'assets/dist/admin/fullcalendar/dist/fullcalendar.min.js'
			'assets/dist/admin/select2/dist/js/select2.full.min.js'
		),
		'foot'	=> array(
		),
	),

	// Default stylesheets to embed at page head
	'stylesheets' => array(
		'screen' => array(
			'assets/dist/admin/adminlte.min.css',
			'assets/dist/admin/lib.min.css',
			'assets/dist/admin/packages/core/main.css',
			'assets/dist/admin/packages/daygrid/main.css',
			'assets/dist/admin/packages/timegrid/main.css',
			'assets/dist/admin/packages/list/main.css',
			'assets/dist/admin/css/bootstrap-datetimepicker.min.css',
			'assets/dist/admin/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css',
			// 'assets/dist/admin/fullcalendar/dist/fullcalendar.min.css',
			// 'assets/dist/admin/fullcalendar/dist/fullcalendar.print.min.css',
			'assets/dist/admin/app.min.css',
			'assets/dist/admin/select2/dist/css/select2.min.css'
		)
	),

	// Default CSS class for <body> tag
	'body_class' => '',
	
	// Multilingual settings
	'languages' => array(
	),

	// Menu items
	'menu' => array(
		'home' => array(
			'name'		=> 'Home',
			'url'		=> '',
			'icon'		=> 'fa fa-home',
		),
		'users' => array(
			'name'		=> 'Users',
			'url'		=> 'user',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List'			=> 'users',
				'Create'		=> 'users/create',
				'Import User'	=> 'users/import',
			)
		),
		'media' => array(
			'name'		=> 'Media',
			'url'		=> 'media',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Inbound'		=> 'media/inventory',
			)
		),
		'inventory' => array(
			'name'		=> 'Inventory',
			'url'		=> 'inventory',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List Stock'	=> 'inventory',
				'Inbound'		=> 'inventory/inbound',
				'Outbound'		=> 'inventory/outbound',
				'Return'	=> 'inventory/return',
			)
		),
		'Report' => array(
			'name'		=> 'Report',
			'url'		=> 'report',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Inbound'		=> 'report/inbound',
				'Outbound'		=> 'report/outbound',
				'Return'	=> 'report/return',
				'Sales Movement'	=> 'report/export/selisih-movement',
			)
		),
		'FAQ' => array(
			'name'		=> 'FAQ',
			'url'		=> 'faq',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List'			=> 'faq',
				'Create'		=> 'faq/create',
				'Import FAQ'	=> 'faq/import',
			)
		),
		'Agenda' => array(
			'name'		=> 'Agenda',
			'url'		=> 'agenda',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Calendar'		=> 'agenda',
				'List'			=> 'agenda/list',
			)
		),
		'Breakdown' => array(
			'name'		=> 'Breakdown',
			'url'		=> 'breakdown',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Data Sales'	=> 'breakdown',
			)
		),
		'Data Product' => array(
			'name'		=> 'Product',
			'url'		=> 'product',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Master Product'	=> 'product/master',
				'Barcode Product'	=> 'product/barcode',
				'Detail Bundling'	=> 'product/bundling',
				// 'Create'			=> 'product/create',
				// 'Import Product'	=> 'product/import',
			)
		),
		'Brand' => array(
			'name'		=> 'Brand',
			'url'		=> 'brand',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List'			=> 'brand',
			)
		),
		'links' => array(
			'name'		=> 'Links',
			'url'		=> 'links',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List'			=> 'links',
			)
		),
		'customer' => array(
			'name'		=> 'Customer',
			'url'		=> 'customers',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Customer Web'			=> 'customers/website',
				'Customer Lazada'		=> 'customers/lazada',
			)
		),
		'orders' => array(
			'name'		=> 'All Orders',
			'url'		=> 'orders',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Orders Web'		=> 'orders/website',
				'Orders Tokopedia'		=> 'orders/tokopedia',
				'Orders Lazada'		=> 'orders/lazada',
			)
		),
		'panel' => array(
			'name'		=> 'Admin Panel',
			'url'		=> 'panel',
			'icon'		=> 'fa fa-cog',
			'children'  => array(
				'Admin Users'			=> 'panel/admin_user',
				'Create Admin User'		=> 'panel/admin_user_create',
				'Admin User Groups'		=> 'panel/admin_user_group',
			)
		),
		'util' => array(
			'name'		=> 'Utilities',
			'url'		=> 'util',
			'icon'		=> 'fa fa-cogs',
			'children'  => array(
				'Database Versions'		=> 'util/list_db',
			)
		),
		'logout' => array(
			'name'		=> 'Sign Out',
			'url'		=> 'panel/logout',
			'icon'		=> 'fa fa-sign-out',
		)
	),
	// Menu OPR items
	'opr' => array(
		'home' => array(
			'name'		=> 'Home',
			'url'		=> '',
			'icon'		=> 'fa fa-home',
		),
		'media' => array(
			'name'		=> 'Media',
			'url'		=> 'media',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Inbound'		=> 'media/inventory',
			)
		),
		'inventory' => array(
			'name'		=> 'Inventory',
			'url'		=> 'inventory',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List Stock'	=> 'inventory',
				'Inbound'		=> 'inventory/inbound',
				'Outbound'		=> 'inventory/outbound',
				'Return'	=> 'inventory/return',
			)
		),
		'Report' => array(
			'name'		=> 'Report',
			'url'		=> 'report',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Inbound'		=> 'report/inbound',
				'Outbound'		=> 'report/outbound',
				'Return'	=> 'report/return',
				'Sales Movement'	=> 'report/export/selisih-movement',
			)
		),
		'logout' => array(
			'name'		=> 'Sign Out',
			'url'		=> 'panel/logout',
			'icon'		=> 'fa fa-sign-out',
		)
	),
	// Menu BD items
	'bd' => array(
		'home' => array(
			'name'		=> 'Home',
			'url'		=> '',
			'icon'		=> 'fa fa-home',
		),
		'inventory' => array(
			'name'		=> 'Inventory',
			'url'		=> 'inventory',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List Stock'	=> 'inventory',
				'Inbound'		=> 'inventory/inbound',
				'Outbound'		=> 'inventory/outbound',
				'Peminjaman'	=> 'inventory/peminjaman',
				'Pengembalian'	=> 'inventory/pengembalian',
			)
		),
		'Agenda' => array(
			'name'		=> 'Agenda',
			'url'		=> 'agenda',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Calendar'		=> 'agenda',
				'List'			=> 'agenda/list',
			)
		),
		'Breakdown' => array(
			'name'		=> 'Breakdown',
			'url'		=> 'breakdown',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Data Sales'	=> 'breakdown',
			)
		),
		'Data Product' => array(
			'name'		=> 'Product',
			'url'		=> 'product',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Master Product'	=> 'product/master',
				'Detail Bundling'	=> 'product/bundling',
				'Barcode Product'	=> 'product/barcode',
				// 'Create'			=> 'product/create',
				// 'Import Product'	=> 'product/import',
			)
		),
		'Brand' => array(
			'name'		=> 'Brand',
			'url'		=> 'brand',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List'			=> 'brand',
			)
		),
		'links' => array(
			'name'		=> 'Links',
			'url'		=> 'links',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'List'			=> 'links',
			)
		),
		'customer' => array(
			'name'		=> 'Customer',
			'url'		=> 'customers',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Customer Web'			=> 'customers/website',
				'Customer Lazada'		=> 'customers/lazada',
			)
		),
		'orders' => array(
			'name'		=> 'All Orders',
			'url'		=> 'orders',
			'icon'		=> 'fa fa-users',
			'children'  => array(
				'Orders Web'		=> 'orders/website',
				'Orders Tokopedia'		=> 'orders/tokopedia',
				'Orders Lazada'		=> 'orders/lazada',
			)
		),
		'logout' => array(
			'name'		=> 'Sign Out',
			'url'		=> 'panel/logout',
			'icon'		=> 'fa fa-sign-out',
		)
	),

	// Login page
	'login_url' => 'admin/login',

	// Restricted pages
	'page_auth' => array(
		'user/create'				=> array('webmaster', 'admin', 'manager'),
		'user/group'				=> array('webmaster', 'admin', 'manager'),
		'panel'						=> array('webmaster'),
		'panel/admin_user'			=> array('webmaster'),
		'panel/admin_user_create'	=> array('webmaster'),
		'panel/admin_user_group'	=> array('webmaster'),
		'util'						=> array('webmaster'),
		'util/list_db'				=> array('webmaster'),
		'util/backup_db'			=> array('webmaster'),
		'util/restore_db'			=> array('webmaster'),
		'util/remove_db'			=> array('webmaster'),
	),

	// AdminLTE settings
	'adminlte' => array(
		'body_class' => array(
			'webmaster'	=> 'skin-red',
			'admin'		=> 'skin-purple',
			'manager'	=> 'skin-black',
			'staff'		=> 'skin-blue',
		)
	),

	// Useful links to display at bottom of sidemenu
	'useful_links' => array(
		array(
			'auth'		=> array('webmaster', 'admin', 'manager', 'staff'),
			'name'		=> 'Frontend Website',
			'url'		=> '',
			'target'	=> '_blank',
			'color'		=> 'text-aqua'
		),
		array(
			'auth'		=> array('webmaster', 'admin'),
			'name'		=> 'API Site',
			'url'		=> 'api',
			'target'	=> '_blank',
			'color'		=> 'text-orange'
		),
		/* array(
			'auth'		=> array('webmaster', 'admin', 'manager', 'staff'),
			'name'		=> 'Github Repo',
			'url'		=> CI_BOOTSTRAP_REPO,
			'target'	=> '_blank',
			'color'		=> 'text-green'
		), */
	),

	// Debug tools
	'debug' => array(
		'view_data'	=> FALSE,
		'profiler'	=> FALSE
	),
);

/*
| -------------------------------------------------------------------------
| Override values from /application/config/config.php
| -------------------------------------------------------------------------
*/
$config['sess_cookie_name'] = 'ci_session_admin';