<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Agenda page
 */
class Agenda extends Admin_Controller {

	var $data;

	public function __construct()
	{
		parent::__construct();
		
 
        // load Pagination library
        $this->load->library('pagination');
         
        // load from and url helper optional (in this tutorial)
        $this->load->helper(array(
            'form',
            'url'
        ));
		// Load session
		$this->load->library('session');
        // load database
        $this->load->database();
        // load form validation library
        $this->load->library('form_validation');
		// $this->load->library('phpmailer');
		$this->load->library('form_builder');
		
		// Load model
		$this->load->model('Agenda_model');
		$this->load->model('ReportProduct');
	}

	public function agen(){
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		$query = $this->db->query("SELECT * FROM agenda");
		$agenda = $query->result_array();
		// print_r($agenda);
		foreach($agenda as $r){
			$data_events[] = array(
				"id" => $r['agenda_id'],
				"title" => $r['title'],
				"description" => $r['description'],
				"end" => $r['end'],
				"start" => $r['start'],
				"url" => "agenda/view/".encrypt_decrypt('encrypt', $r['agenda_id']),
				"backgroundColor" => $r['color'],
				"borderColor" => $r['color']
			);
			// echo json_encode($data);
		}
		echo json_encode($data_events);
	}
	
	public function index(){
		// print_r($this->session->userdata('username'));
		$this->mPageTitle = 'Agenda';
		$this->render('agenda/index');
	}
	
	
	public function detail(){
		
		if($_POST['getDetail']) {
			$id = $_POST['getDetail'];
			$query = $this->db->query("SELECT * FROM `product_event` WHERE pe_id='".$id."'");
			$row = $query->row();
			// print_r($row);
			echo"<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">Product</label>
				<div class=\"col-sm-8\">
					$row->name - ($row->fgcode)
				</div>
				<div class=\"col-sm-2\">
				<input type=\"hidden\" name=\"id\" value=\"$id\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">Disc</label>
				<div class=\"col-sm-8\">
					$row->disc
				</div>
				<div class=\"col-sm-2\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">HPP</label>
				<div class=\"col-sm-8\">
					$row->hpp
				</div>
				<div class=\"col-sm-2\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">MT</label>
				<div class=\"col-sm-8\">
					$row->mt
				</div>
				<div class=\"col-sm-2\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">Stock</label>
				<div class=\"col-sm-8\">
					$row->stock
				</div>
				<div class=\"col-sm-2\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">Profit HPP</label>
				<div class=\"col-sm-8\">
					$row->profitHPP
				</div>
				<div class=\"col-sm-2\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">Profit MT</label>
				<div class=\"col-sm-8\">
					$row->profitMT
				</div>
				<div class=\"col-sm-2\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">Note</label>
				<div class=\"col-sm-10\">
					<textarea style=\"width: 100%;\" name=\"note\">$row->note</textarea>
				</div>
			</div>";
		}
	}
	
	
	public function periode(){
		ini_set('error_reporting', E_ALL);
		ini_set("display_errors", "1");
		error_reporting(0);
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		if($_POST['getPeriode']) {
			$id = $_POST['getPeriode'];
			$query = $this->db->query("SELECT * FROM `agenda` WHERE agenda_id='".$id."'");
			$row = $query->row();
			// print_r($row);
			echo"<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">Start</label>
				<div class=\"col-sm-8\">
					<input id=\"new-event\" name=\"start_date\" type=\"text\" class=\"form-control\" value=\"$row->start\">
					<br/><small>$row->start</small>
					</div>
				<div class=\"col-sm-2\">
				<input type=\"hidden\" name=\"id\" value=\"$id\">
				</div>
			</div>
			<div class=\"row\" style=\"margin-bottom: 15px;\">
			  <label for=\"fg\" class=\"col-sm-2 control-label\">End</label>
				<div class=\"col-sm-8\">
					<input id=\"new-event\" name=\"end_date\" type=\"text\" class=\"form-control\" value=\"$row->end\">
					<br/><small>$row->end</small>
				</div>
				<div class=\"col-sm-2\">
				</div>
			</div>";
		}
		
		// if (!empty($_POST['periode'])) {
		if ($_POST['periode']) {
			$q = $this->input->post('q');
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			
			$update = $this->db->query("UPDATE `agenda` SET  `start` = '$start_date', `end` = '$end_date' WHERE `agenda_id` = '$q';");				
			$this->session->set_flashdata('data','Data event berhasil di update.');
			redirect("/admin/agenda/view/".encrypt_decrypt('encrypt', $q));
		}
	}
	
	
	public function new(){
		
		// print_r($this->session->userdata('username'));
		$this->mPageTitle = 'View Agenda';
		$this->render('agenda/view');
		
		
	}
	
	public function view(){
		
		// print_r($this->session->userdata('username'));
		$this->mPageTitle = 'View Agenda';
		$this->render('agenda/new');
		if (!empty($_POST['tes'])) {
		  // submit button pressed
			$eventid = $this->input->post('eventid');
			$mp = $this->input->post('mp');
			$fg = $this->input->post('fg');
			$disc = $this->input->post('disc');
			$stock = $this->input->post('stock');
			$url = $this->input->post('url');
			if($fg ==''){
				echo '<script language="javascript">';
				echo 'alert("FGcode masih kosong")';
				echo '</script>';
			}else if($disc ==''){
				echo '<script language="javascript">';
				echo 'alert("data discount masih kosong")';
				echo '</script>';
			}else if($stock ==''){
				echo '<script language="javascript">';
				echo 'alert("data stock masih kosong")';
				echo '</script>';
			}else{
				// echo"berhasil";
				$query = $this->db->query("SELECT * FROM master_product WHERE FG = '$fg'");
				$row = $query->row();
				// print_r($row);
				// echo $mp;
				// exit;
				if($mp == 'Bukalapak' || $mp == 'Elevenia' || $mp == 'Shopee' || $mp == 'Tokopedia'){
					$harga = $row->Roundup30;
				}
				$vdisc = $harga * $disc / 100;
				$hrgdisc = $harga - $vdisc;
				$ProdName = $row->ProdName;
				$hpp = $row->NewHPP;
				$mt = $row->NewMT;
				$phpp = $hrgdisc - $hpp;
				$pmt = $hrgdisc - $mt;
				$data = $this->db->query("INSERT INTO `product_event` (`agenda_id`, `fgcode`, `name`, `harga`, `disc`, `harga_disc`, `hpp`, `mt`, `stock`, `profitHPP`, `profitMT` )
				VALUES ('$eventid', '$fg', '$ProdName', '$harga', '$disc', '$hrgdisc', '$hpp', '$mt', '$stock', '$phpp', '$pmt');");
				$q = $this->db->insert_id();
				if($data >= 1){
					$this->session->set_flashdata('data','Data link berhasil disimpan.');
					redirect($url);
				}
			}
		} 
	}
	
	public function update(){
		
		$value = $this->input->post('tes');
		$fg = $this->input->post('fg');
		if( $value == "Add" ){
			if(!empty($fg)){
				// echo "berhasil";
				$this->session->set_flashdata('data','Data link berhasil diupdate.');
			}else{
				$this->session->set_flashdata('data','Data link gagal diupdate.');
			}
		}else{
			// echo'gagal';
			$this->session->set_flashdata('data','Data link gagal diupdate.');
		}
	}
	
	public function list(){
		// print_r($this->session->userdata('username'));
		$this->mPageTitle = 'Agenda';
		$this->render('agenda/list');
	}

	public function cari(){
        $fg=$_GET['fg'];
        $data =$this->ReportProduct->cari($fg)->result();
		$this->output->set_header('Content-Type: application/json; charset=utf-8');
        // echo json_encode($data);
        $data = json_encode($data);
        // var_dump($data);
        echo $data;
		// echo 'Ready';
    } 

	public function jajal(){
		print_r($user);
	}
	
	public function checking(){
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		$token =  $this->input->post('id');
		$note = $this->input->post('note');
		$date = date("d-m-Y H:i:s");
		$this->mPageTitle = 'Aktif';
		$update = $this->db->query("UPDATE `product_event` SET  `status` = 'C', `note` = '$note' WHERE `pe_id` = '$token';");
		
		$query = $this->db->query("SELECT * FROM product_event WHERE pe_id = '$token'");
		$row = $query->row();
		
		$this->session->set_flashdata('data','Data product event berhasil di checking.');
		redirect("/admin/agenda/view/".encrypt_decrypt('encrypt', $row->agenda_id));
		
	}
	
	public function approve(){
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		$token =  encrypt_decrypt('decrypt', $this->uri->segment('5'));
		$username = $this->uri->segment('4');
		$date = date("d-m-Y H:i:s");
		$this->mPageTitle = 'Aktif';
		$update = $this->db->query("UPDATE `product_event` SET  `status` = 'Y', `approved_by` = '$username', `approved_date` = 'NOW()' WHERE `pe_id` = '$token';");
		
		$query = $this->db->query("SELECT * FROM product_event WHERE pe_id = '$token'");
		$row = $query->row();
		
		$this->session->set_flashdata('data','Data product event berhasil di approve.');
		redirect("/admin/agenda/view/".encrypt_decrypt('encrypt', $row->agenda_id));
		
	}
	
	public function reject(){
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		$token = encrypt_decrypt('decrypt', $this->uri->segment('5'));
		$username = $this->uri->segment('4');
		$date = date("d-m-Y H:i:s");
		$this->mPageTitle = 'Non Aktif';
		$update = $this->db->query("UPDATE `product_event` SET  `status` = 'N', `approved_by` = '$username', `approved_date` = 'NOW()' WHERE `pe_id` = '$token';");
		
		$query = $this->db->query("SELECT * FROM product_event WHERE pe_id = '$token'");
		$row = $query->row();
		
		$this->session->set_flashdata('data','Data product event berhasil di reject.');
		redirect("/admin/agenda/view/".encrypt_decrypt('encrypt', $row->agenda_id));
	}
	
	public function save(){
		if(isset($_POST['preview'])){
	        $title = $this->input->post('title');
			$description = $this->input->post('description');
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$mp = htmlspecialchars($this->input->post('mp'), ENT_QUOTES,"UTF-8");
			$user = $this->session->userdata('username');
			
			$data = $this->db->query("INSERT INTO `agenda` (`title`, `description`, `color`, `start`, `end`, `create_by` )
				VALUES ('$title', '$description', '$mp', '$start_date', '$end_date', '$user');");
				$q = $this->db->insert_id();
				if($data >= 1){
					$this->session->set_flashdata('data','Data agenda berhasil disimpan.');
					redirect("/admin/agenda");
				}
		}
	}
	
}