<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Breakdown extends Admin_Controller {
	private $filename = "import_data"; // Kita tentukan nama filenya

    public function __construct(){
        parent::__construct();
		error_reporting(E_ALL & ~E_NOTICE);
        // load from and url helper optional (in this tutorial)
        $this->load->helper(array(
            'form',
            'url'
        ));
        // load Pagination library
        $this->load->library('pagination');
        // load database
        $this->load->database();
        // load form validation library
        $this->load->library('form_validation');
		// $this->load->library('phpmailer');
		// Load model
		$this->load->model('BreakdownModel');
    }
	
	// Frontend User CRUD
	public function index(){
		$this->mPageTitle = 'List sales';
		$this->render('breakdown/index');
	}
	
	public function form(){
		$this->mPageTitle = 'List sales';
		$this->render('breakdown/import');
	}
	
	public function hapus(){
		$this->db->empty_table('r_test');
		?>
		<script type="text/javascript">
		alert("Data sales berhasil dihapus.");
		window.location.href = "./.";
		</script>
		<?php
	}
	
	public function import(){
		// Load plugin PHPExcel nya
		include APPPATH.'third_party/PHPExcel/PHPExcel.php';
		
		$excelreader = new PHPExcel_Reader_Excel2007();
		$loadexcel = $excelreader->load('excel/'.$this->filename.'.xlsx'); // Load file yang telah diupload ke folder excel
		$sheet = $loadexcel->getActiveSheet()->toArray(null, true, true ,true);
		
		// Buat sebuah variabel array untuk menampung array data yg akan kita insert ke database
		$data = [];
		
		$numrow = 1;
		foreach($sheet as $row){
			// Cek $numrow apakah lebih dari 1
			// Artinya karena baris pertama adalah nama-nama kolom
			// Jadi dilewat saja, tidak usah diimport
			if($numrow > 1){
				// Kita push (add) array data ke variabel data
				array_push($data, [
					'mp' => $row['B'],
					'channel' => $row['C'],
					'thn' => $row['D'],
					'bln' => $row['E'],
					'tgl' => $row['F'],
					'order_item_id' => $row['G'],
					'seller_sku' => $row['H'],
					'item_name' => $row['I'],
					'brand' => $row['J'],
					'qty' => $row['K'],
					'price' => $row['L'],
					'status' => $row['M'],
					'order_id' => $row['N'],
					'unik' => $row['O'],
					'segment' => $row['P'],
				]);
			}
			
			$numrow++; // Tambah 1 setiap kali looping
		}

		// Panggil fungsi insert_multiple yg telah kita buat sebelumnya di model
		$this->BreakdownModel->insert_multiple($data);
		
		redirect("admin/breakdown"); // Redirect ke halaman awal (ke controller siswa fungsi index)
	}
	
	public function export(){
		$tgl = date("M-Y", strtotime("-1 months"));
		$title="NEW-SalesReport-Closing-".$tgl;
		header("Content-type: application/vnd-ms-excel"); 
		// // header("Content-Type: text/csv");
		// // header("Content-Type: text/plain");	
		header("Content-Disposition: attachment; filename=$title.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		?>
			
		<table border="1" cellpadding="8">
			<tr>
				<th>No</th>
				<th>Type</th>
				<th>Channel</th>
				<th>Year</th>
				<th>Month</th>
				<th>Day</th>
				<th>Type</th>
				<th>Order Id</th>
				<th>Order Item id</th>
				<th>Seller SKU</th>
				<th>SKU Item</th>
				<th>Item Name</th>
				<th>Brand</th>
				<th>Qty Order</th>
				<th>Qty Item</th>
				<th>Sum Price</th>
				<th>PL SKU</th>
				<th>CBP Bundling</th>
				<th>Kontribusi</th>
				<th>PL Bundling</th>
				<th>PL Product</th>
				<th>Status</th>
				<th>Segment</th>
			</tr>

			<?php
			$data['report'] = $this->BreakdownModel->view();
			$report = $data['report'];
			if( ! empty($report)){ // Jika data pada database tidak sama dengan empty (alias ada datanya)
				$no=1;
				foreach($report as $data){ // Lakukan looping pada variabel siswa dari controller
					$sku_bundling=$data->seller_sku;
					// $query=$this->db->query("SELECT COUNT(*) AS jumlah FROM sku_mapping WHERE FG_Bundling='$sku_bundling'");
					$query=$this->db->query("SELECT * FROM sku_mapping WHERE FG_Bundling='$sku_bundling'");
					$detail = $query->num_rows();
					// print_r($detail);
					// exit;
					if($detail == 0){
						$channel=$data->channel;
						
						// $satu=$this->db->query("SELECT * FROM sku_product WHERE SKU='$data->seller_sku'");
						$satu=$this->db->query("SELECT * FROM sku_product WHERE FG='$data->seller_sku'");
						$dsatu = $satu->row();
						echo "<tr>";
						echo "<td>".$no."</td>";
						echo "<td>".$data->mp."</td>";
						echo "<td>".$data->channel."</td>";
						echo "<td>".$data->thn."</td>";
						echo "<td>".$data->bln."</td>";
						echo "<td>".$data->tgl."</td>";
						echo "<td>Single</td>";
						echo "<td style='mso-number-format:\@'>".$data->order_id."</td>";
						echo "<td style='mso-number-format:\@'>".$data->order_item_id."</td>";
						echo "<td>".$data->seller_sku."</td>";
						echo "<td></td>";
						echo "<td>".$data->item_name."</td>";
						echo "<td>".$data->brand."</td>";
						echo "<td>".$data->qty."</td>";
						echo "<td></td>";
						echo "<td>".$data->price."</td>";
						echo "<td>";
						if ($channel == 'Lazada'){
								echo $dsatu->Lazada;
						}elseif ($channel == 'Lazada SB'){
								echo $dsatu->Lazada_SB;
						}elseif ($channel == 'Lazada KPWMI'){
								echo $dsatu->Lazada_KPWMI;
						}elseif ($channel == 'Shopee'){
								echo $dsatu->Shopee;
						}elseif ($channel == 'Shopee KPWMI'){
								echo $dsatu->Shopee_KPWMI;
						}elseif ($channel == 'Tokopedia'){
								echo $dsatu->Tokopedia;
						}elseif ($channel == 'Tokopedia KPWMI'){
								echo $dsatu->Tokopedia_KPWMI;
						}elseif ($channel == 'Dunia Halal'){
								echo $dsatu->Duha;
						}elseif ($channel == 'Ruparupa'){
								echo $dsatu->Ruparupa;
						}elseif ($channel == 'Zilingo'){
								echo $dsatu->Zilingo;
						}elseif ($channel == 'iLotte'){
								echo $dsatu->iLotte;
						}elseif ($channel == 'Akulaku'){
								echo $dsatu->Akulaku;
						}elseif ($channel == 'Matahari Mall'){
								echo $dsatu->Mataharimall;
						}elseif ($channel == 'Jakmall'){
								echo $dsatu->Jakmall;
						}elseif ($channel == 'Elevenia'){
								echo $dsatu->Elevenia;
						}elseif ($channel == 'Blanja'){
								echo $dsatu->Blanja;
						}elseif ($channel == 'Bukalapak'){
								echo $dsatu->Bukalapak;
						}elseif ($channel == 'Bukalapak KPWMI'){
								echo $dsatu->Bukalapak_KPWMI;
						}elseif ($channel == 'GoApotik'){
								echo $dsatu->GoApotik;
						}elseif ($channel == 'Alfacart'){
								echo $dsatu->Alfacart;
						}elseif ($channel == 'Blibli'){
								echo $dsatu->Blibli;
						}elseif ($channel == 'Orami'){
								echo $dsatu->Orami;
						}elseif ($channel == 'JD.id'){
								echo $dsatu->JDID;
						}elseif ($channel == 'ShopeeB2B'){
								echo $dsatu->ShopeeB2B;
						}elseif ($channel == 'AkuGrosir'){
								echo $dsatu->AkuGrosir;
						}elseif ($channel == 'Tororo'){
								echo $dsatu->Tororo;
						}elseif ($channel == 'Farmaku'){
								echo $dsatu->Farmaku;
						}elseif ($channel == 'Gogobli'){
								echo $dsatu->Gogobli;
						}elseif ($channel == 'KUDO'){
								echo $dsatu->KUDO;
						}
						echo"</td>";
						echo "<td>0</td>";
						echo "<td>0</td>";
						echo "<td>0</td>";
						echo "<td>0</td>";
						echo "<td>".$data->status."</td>";
						echo "<td>".$data->segment."</td>";
						echo "</tr>";
						$no++;
					}else{
						$nomor = $no;
						$marketplace = $data->mp;
						$channel = $data->channel;
						$tahun = $data->thn;
						$bulan = $data->bln;
						$tanggal = $data->tgl;
						$order_id = $data->order_id;
						$order_item_id = $data->order_item_id;
						$seller_sku = $data->seller_sku;
						$item_name = $data->item_name;
						$brand = $data->brand;
						$qty = $data->qty;
						$price = $data->price;
						$status = $data->status;
						$segment = $data->segment;
						// $qdetail=$this->db->query("SELECT * FROM sku_mapping WHERE FG_Bundling='$sku_bundling'");
						// $pecah = $qdetail->result_array();
						// print_r($pecah);
						// exit;
						foreach($query->result_array() as $pecah){
							$type=$pecah['Type'];
							$FG_Satuan=$pecah['FG_Satuan'];
							// echo "SELECT * FROM sku_product WHERE SKU='$FG_Satuan'";
							// exit;
							if($type == 'Bundling'){
								echo "<tr>";
								// print_r($detail);
								// exit;
								// if ($channel == 'Lazada'){
									// $cl=$detail->Lazada;
								// }
								$satuan=$this->db->query("SELECT * FROM sku_product WHERE FG='$FG_Satuan'");
								$detail = $satuan->row();
								$total = $this->db->query("SELECT SUM(sku_product.Lazada) AS Total FROM sku_product
													JOIN sku_mapping on sku_product.FG = sku_mapping.FG_Satuan
													WHERE sku_mapping.FG_Bundling='$seller_sku'");
								$sum=$total->row();
								echo "<td>".$nomor."</td>";
								echo "<td>".$marketplace."</td>";
								echo "<td>".$channel."</td>";
								echo "<td>".$tahun."</td>";
								echo "<td>".$bulan."</td>";
								echo "<td>".$tanggal."</td>";
								echo "<td>".$type."</td>";
								echo "<td style='mso-number-format:\@'>".$order_id."</td>";	
								echo "<td style='mso-number-format:\@'>".$order_item_id."</td>";	
								echo "<td>".$seller_sku."</td>";
								echo "<td>".$pecah['FG_Satuan']."</td>";
								echo "<td>".$item_name."</td>";
								echo "<td>".$brand."</td>";
								echo "<td>".$qty."</td>";
								echo "<td>".$pecah['QTY'] * $qty."</td>";
								// echo "<td>".$price."</td>";
								if ($channel == 'Lazada'){
									$persen = number_format($detail->Lazada / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Lazada."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Lazada SB'){
									$persen = number_format($detail->Lazada_SB / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Lazada_SB."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Lazada KPWMI'){
									$persen = number_format($detail->Lazada_KPWMI / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Lazada_KPWMI."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Shopee'){
									$persen = number_format($detail->Shopee / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Shopee."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Shopee KPWMI'){
									$persen = number_format($detail->Shopee_KPWMI / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Shopee_KPWMI."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Tokopedia'){
									$persen = number_format($detail->Tokopedia / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Tokopedia."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Tokopedia KPWMI'){
									$persen = number_format($detail->Tokopedia_KPWMI / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Tokopedia_KPWMI."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Dunia Halal'){
									$persen = number_format($detail->Duha / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Duha."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Ruparupa'){
									$persen = number_format($detail->Ruparupa / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Ruparupa."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Zilingo'){
									$persen = number_format($detail->Zilingo / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Zilingo."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'iLotte'){
									$persen = number_format($detail->iLotte / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->iLotte."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Akulaku'){
									$persen = number_format($detail->Akulaku / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Akulaku."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Matahari Mall'){
									$persen = number_format($detail->Mataharimall / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Mataharimall."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Jakmall'){
									$persen = number_format($detail->Jakmall / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Jakmall."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Elevenia'){
									$persen = number_format($detail->Elevenia / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Elevenia."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Blanja'){
									$persen = number_format($detail->Blanja / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Blanja."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Bukalapak'){
									$persen = number_format($detail->Bukalapak / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Bukalapak."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Bukalapak KPWMI'){
									$persen = number_format($detail->Bukalapak_KPWMI / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Bukalapak_KPWMI."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'GoApotik'){
									$persen = number_format($detail->GoApotik / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->GoApotik."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Alfacart'){
									$persen = number_format($detail->Alfacart / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Alfacart."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Blibli'){
									$persen = number_format($detail->Blibli / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Blibli."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Orami'){
									$persen = number_format($detail->Orami / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Orami."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'JD.id'){
									$persen = number_format($detail->JDID / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->JDID."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'ShopeeB2B'){
									$persen = number_format($detail->ShopeeB2B / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->ShopeeB2B."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'AkuGrosir'){
									$persen = number_format($detail->AkuGrosir / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->AkuGrosir."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Tororo'){
									$persen = number_format($detail->Tororo / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Tororo."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Farmaku'){
									$persen = number_format($detail->Farmaku / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Farmaku."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'Gogobli'){
									$persen = number_format($detail->Gogobli / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->Gogobli."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}elseif ($channel == 'KUDO'){
									$persen = number_format($detail->KUDO / $sum->Total * 100, 1);
									$jual = $persen * str_replace(",","",$price) / 100;
										echo "<td>".$data->price."</td>";
										echo "<td>".$detail->KUDO."</td>";
										echo "<td>".str_replace(",",".",$price)."</td>";
										echo "<td>".$persen."</td>";
										echo "<td>".$sum->Total."</td>";
										echo "<td>".$jual."</td>";
								}
								echo "<td>".$status."</td>";
								echo "<td>".$segment."</td>";
								echo "</tr>";
								$no++;
							}elseif($type == 'Multipack'){
										
								// $multi=$this->db->query("SELECT * FROM sku_product WHERE SKU='$seller_sku'");
								$multi=$this->db->query("SELECT * FROM sku_product WHERE FG='$seller_sku'");
								$dmulti = $multi->row();
								echo "<tr>";
								echo "<td>".$no."</td>";
								echo "<td>".$marketplace."</td>";
								echo "<td>".$channel."</td>";
								echo "<td>".$tahun."</td>";
								echo "<td>".$bulan."</td>";
								echo "<td>".$tanggal."</td>";
								echo "<td>".$type."</td>";
								echo "<td style='mso-number-format:\@'>".$order_id."</td>";	
								echo "<td style='mso-number-format:\@'>".$order_item_id."</td>";	
								echo "<td>".$seller_sku."</td>";
								echo "<td>".$pecah['FG_Satuan']."</td>";
								echo "<td>".$item_name."</td>";
								echo "<td>".$brand."</td>";
								echo "<td>".$qty."</td>";
								echo "<td>".$pecah['QTY'] * $qty."</td>";
								echo "<td>".$price."</td>";
								echo "<td>";
								if ($channel == 'Lazada'){
										echo $dmulti->Lazada;
								}elseif ($channel == 'Lazada SB'){
										echo $dmulti->Lazada_SB;
								}elseif ($channel == 'Lazada KPWMI'){
										echo $dmulti->Lazada_KPWMI;
								}elseif ($channel == 'Shopee'){
										echo $dmulti->Shopee;
								}elseif ($channel == 'Shopee KPWMI'){
										echo $dmulti->Shopee_KPWMI;
								}elseif ($channel == 'Tokopedia'){
										echo $dmulti->Tokopedia;
								}elseif ($channel == 'Tokopedia KPWMI'){
										echo $dmulti->Tokopedia_KPWMI;
								}elseif ($channel == 'Dunia Halal'){
										echo $dmulti->Duha;
								}elseif ($channel == 'Ruparupa'){
										echo $dmulti->Ruparupa;
								}elseif ($channel == 'Zilingo'){
										echo $dmulti->Zilingo;
								}elseif ($channel == 'iLotte'){
										echo $dmulti->iLotte;
								}elseif ($channel == 'Akulaku'){
										echo $dmulti->Akulaku;
								}elseif ($channel == 'Matahari Mall'){
										echo $dmulti->Mataharimall;
								}elseif ($channel == 'Jakmall'){
										echo $dmulti->Jakmall;
								}elseif ($channel == 'Elevenia'){
										echo $dmulti->Elevenia;
								}elseif ($channel == 'Blanja'){
										echo $dmulti->Blanja;
								}elseif ($channel == 'Bukalapak'){
										echo $dmulti->Bukalapak;
								}elseif ($channel == 'Bukalapak KPWMI'){
										echo $dmulti->Bukalapak_KPWMI;
								}elseif ($channel == 'GoApotik'){
										echo $dmulti->GoApotik;
								}elseif ($channel == 'Alfacart'){
										echo $dmulti->Alfacart;
								}elseif ($channel == 'Blibli'){
										echo $dmulti->Blibli;
								}elseif ($channel == 'Orami'){
										echo $dmulti->Orami;
								}elseif ($channel == 'JD.id'){
										echo $dmulti->JDID;
								}elseif ($channel == 'ShopeeB2B'){
										echo $dmulti->ShopeeB2B;
								}elseif ($channel == 'AkuGrosir'){
										echo $dmulti->AkuGrosir;
								}elseif ($channel == 'Tororo'){
										echo $dmulti->Tororo;
								}elseif ($channel == 'Farmaku'){
										echo $dmulti->Farmaku;
								}elseif ($channel == 'Gogobli'){
										echo $dmulti->Gogobli;
								}elseif ($channel == 'KUDO'){
										echo $dmulti->KUDO;
								}
								echo"</td>";
								echo "<td>0</td>";
								echo "<td>0</td>";
								echo "<td>0</td>";
								echo "<td>0</td>";
								echo "<td>".$status."</td>";
								echo "<td>".$segment."</td>";
								echo "</tr>";
								$no++;
							}
						}
					}
				}
			}else{ // Jika data tidak ada
				echo "<tr><td colspan='18'>Data tidak ada</td></tr>";
			}
			?>
		</table>
		<?php
	}
	
	
}