<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory extends Admin_Controller {

    public function __construct(){
        parent::__construct();
        // load from and url helper optional (in this tutorial)
        $this->load->helper(array(
            'form',
            'url'
        ));
        // load Pagination library
        $this->load->library('pagination');
        // load database
        $this->load->database();
        // load form validation library
        $this->load->library('form_validation');
		// $this->load->library('phpmailer');
		// Load model
		$this->load->model('ReportProduct');
    }
	
	// Frontend User CRUD
	public function index(){
		$this->mPageTitle = 'List stock';
		$this->render('inventory/index');
	}
	
	public function view(){
		$type= $this->uri->segment('4');
		$token= $this->uri->segment('5');
		if($type == 'inbound'){
			$this->mPageTitle = 'View Inbound';
			$this->render('inventory/viewinbound');
		}else if($type == 'outbound'){
			$this->mPageTitle = 'View Outbound';
			$this->render('inventory/viewoutbound');
		}else if($type == 'return'){
			$this->mPageTitle = 'View Return';
			$this->render('inventory/viewreturn');
		}
	}
	
	public function inboundnew(){
		$this->mPageTitle = 'Inbound';
		$this->render('inventory/inboundnew');
	}
	
	public function inbound(){
		$this->mPageTitle = 'List Master Inbound';
		$this->render('inventory/listinbound');
	}
	
	public function return(){
		$this->mPageTitle = 'List Master Return';
		$this->render('inventory/listreturn');
	}
	
	public function exout(){
		$this->mPageTitle = 'List Export';
		$this->render('inventory/exout');
	}
	
	public function create(){
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		
		$this->mPageTitle = 'Create Inventory';
		if($this->input->post('type') == 'po'){
			$config['upload_path']          = './assets/uploads/inventory/';
			$config['allowed_types']        = 'gif|jpg|jpeg|png';
			$new_name 						= time().'-'.$_FILES["fileimg"]['name'];
			$config['file_name'] 			= $new_name;
			
			if(!empty($this->input->post('po') && $this->input->post('do'))){
				move_uploaded_file($_FILES['fileimg']['tmp_name'],"./assets/uploads/inventory/". $new_name);
				
				$this->load->library('upload', $config);
				$data = array('upload_data' => $this->upload->data());
				
				$type = $this->input->post('type');
				$user = $this->input->post('user');
				$po = $this->input->post('po');
				$do = $this->input->post('do');
				$reff = $this->input->post('no_reff');
				$delivery = $this->input->post('delivery');
				$file = $this->upload->data('file_name');
				$url = $this->upload->data('upload_path');
				$delivery = $this->input->post('delivery');
				
				$data = $this->db->query("INSERT INTO `inventory` (`type`, `no_po`, `no_do`, `no_reff`, `delivery_date`, `file`, `url`, `userUpload` )
				VALUES ('$type', '$po', '$do', '$reff', '$delivery', '$file', '$url', '$user');");
				$q = $this->db->insert_id();
				if($data >= 1){
					$this->session->set_flashdata('data','Data Inbound berhasil disimpan.');
					redirect("/admin/inventory/add/inbound/".encrypt_decrypt('encrypt', $q));
				}
			}
		}else if($this->input->post('type') == 'do'){
			
			$type = $this->input->post('type');
			$user = $this->input->post('user');
			$do = $this->input->post('do');
			
			$data = $this->db->query("INSERT INTO `inventory` (`type`, `no_do`, `userUpload` )
			VALUES ('$type', '$do', '$user');");
			$q = $this->db->insert_id();
			if($data >= 1){
				$this->session->set_flashdata('data','Data Outbound berhasil disimpan.');
				redirect("/admin/inventory/add/outbound/".encrypt_decrypt('encrypt', $q));
			}
		}else if($this->input->post('type') == 're'){
			
			$type = $this->input->post('type');
			$user = $this->input->post('user');
			$re = $this->input->post('re');
			$reff = $this->input->post('reff');
			
			$data = $this->db->query("INSERT INTO `inventory` (`type`, `no_po`, `no_do`, `no_reff`, `userUpload` )
			VALUES ('$type', '$re', '$reff', '', '$user');");
			$q = $this->db->insert_id();
			if($data >= 1){
				$this->session->set_flashdata('data','Data return berhasil disimpan.');
				redirect("/admin/inventory/add/return/".encrypt_decrypt('encrypt', $q));
			}
		}

	}
	
	
	public function add(){
		$type = $this->uri->segment('4');
		$token = $this->uri->segment('5');
		if($type == 'inbound'){
			$this->mPageTitle = 'Create Inventory';
			// echo'ini page inbound<br/>'.$token;
			$this->render('inventory/inboundnew');
		}else if($type == 'outbound'){
			$this->mPageTitle = 'Add Product Outbound';
			// echo'ini page outbound<br/>'.$token;
			$this->render('inventory/outbound');
		}else if($type == 'return'){
			$this->mPageTitle = 'Add Product Return';
			// echo'ini page outbound<br/>'.$token;
			$this->render('inventory/return');
		}
	}
	
	public function outbound(){
		$this->mPageTitle = 'List Master Outbound';
		$this->render('inventory/listoutbound');
	}
	
	public function GetBarcode(){ 
        $barcode=$_GET['barcode'];
		$query = $this->db->query("SELECT * FROM `master_product` WHERE `Type`='Single'");
		// $row = $query->row();
		$json = array();
		$row = $query->result_array();
		foreach($row as $info) {
			$json[] = array(
				'fg' => $info['FG'],
				'value' => $info['FG'] .' - '.$info['ProdName'],
				'UOM' => $info['UOM']
			);
		}
		$this->output->set_header('Content-Type: application/json; charset=utf-8');
		echo json_encode($json);
	}
	
	public function GetBarcodedua(){ 
        $barcode=$_GET['barcode'];
		$query = $this->db->query("SELECT * FROM `master_product` WHERE `Type`='Single'");
		// $row = $query->row();
		$json = array();
		$row = $query->result_array();
		foreach($row as $info) {
			$json[] = array(
				'fg' => $info['FG'],
				'value' => $info['FG'] .' - '.$info['ProdName'],
				'UOM' => $info['UOM']
			);
		}
		$this->output->set_header('Content-Type: application/json; charset=utf-8');
		echo json_encode($json);
	}
	
	/* public function save(){
		// var_dump($POST);
		// exit;
		// if(!empty($this->input->post('fullname') && $this->input->post('email'))){
		$config['upload_path']          = './assets/uploads/brand/';
		$config['allowed_types']        = 'gif|jpg|png';
		$new_name 						= time().'-'.$_FILES["file"]['name'];
		$config['file_name'] 			= $new_name;
		
		if(move_uploaded_file($_FILES['file']['tmp_name'],"./assets/uploads/brand/". $new_name)){
		
			$this->load->library('upload', $config);
			$data = array('upload_data' => $this->upload->data());
			/* 
			var_dump($data);
			echo"<br/>";
			//echo $this->upload->data('file_name'); 
			// exit;
	        $nama = $this->input->post('nama');
			$link = $this->input->post('link');
			$position = $this->input->post('position');
			$file = $this->upload->data('file_name');
			
			$data = $this->db->query("INSERT INTO `brand` (`name_brand`, `img_brand`, `link_brand`, `status_brand` )
				VALUES ('$nama', '$file', '$link', 'Y');");
				$q = $this->db->insert_id();
				// $tes = encrypt_decrypt('encrypt', $q);
				if($data >= 1){
					$this->session->set_flashdata('data','Data Brand berhasil disimpan.');
					redirect("/admin/brand");
				}else{
					$this->session->set_flashdata('data','Data Brand gagal disimpan.');
					redirect("/admin/brand");
				}
		}else{
			$this->session->set_flashdata('data','Periksa kembali file images brand.');
					redirect("/admin/brand");
		}
	} */
}