<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Links extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
        // load from and url helper optional (in this tutorial)
        $this->load->helper(array(
            'form',
            'url'
        ));
        // load database
        $this->load->database();
        // load form validation library
        $this->load->library('form_validation');
		// $this->load->library('phpmailer');
		$this->load->library('form_builder');
	}

	// Frontend User CRUD
	public function index(){
		error_reporting(0);
		$this->mPageTitle = 'Links';
		$this->render('links/index');
		
	}
	
	public function update(){
		
		$this->mPageTitle = 'Update Link';
		$this->render('links/update');
	}
	
	public function aktif(){
		$token = $this->uri->segment('4');
		$this->mPageTitle = 'Aktif Link';
		$update = $this->db->query("UPDATE `link_list` SET  `aktif` = 'Y' WHERE `id` = '$token';");
		
		$this->session->set_flashdata('data','Data link berhasil di aktifkan.');
		redirect("/admin/links");
		
	}
	
	public function non_aktif(){
		$token = $this->uri->segment('4');
		$this->mPageTitle = 'Non Aktif Link';
		$update = $this->db->query("UPDATE `link_list` SET  `aktif` = 'N' WHERE `id` = '$token';");
		
		$this->session->set_flashdata('data','Data link berhasil di non aktifkan.');
		redirect("/admin/links");
	}
	
	public function save(){
		
		if(isset($_POST['preview'])){
			$token = $this->input->post('token');
			$kategori = $this->input->post('kat');
			$nama = $this->input->post('nama');
			$desk = $this->input->post('desk');
			$link = $this->input->post('link');
			$tanggal1 = $this->input->post('tanggal1');
			$bln1 = $this->input->post('bln1');
			$thn1 = $this->input->post('thn1');
			$tanggal2 = $this->input->post('tanggal2');
			$bln2 = $this->input->post('bln2');
			$thn2 = $this->input->post('thn2');
			$promo = $this->input->post('promo');
			if($token==""){
				// echo "Kosong";
				redirect("http://partnership.kinostore.co.id/admin/links");
			}else{
				$update = $this->db->query("UPDATE `link_list` SET `kategori` = '$kategori', `nama` = '$nama', `desc` = '$desk', `linkaja` = '$link', `tanggal1` = '$tanggal1', `bulan1` = '$bln1', `tahun1` = '$thn1', `tanggal2` = '$tanggal2', `bulan2` = '$bln2', `tahun2` = '$thn2', `kodein` = '$promo' WHERE `id` = '$token';");
				// echo "Berhasil";
				// redirect("http://partnership.kinostore.co.id/admin/links/update/'.$token.'");
				
				$this->session->set_flashdata('data','Data link berhasil diupdate.');
				redirect("/admin/links/update/".$token);
			}
		}
	}
	
	// Create Frontend User
	public function create(){
		$config['upload_path']          = './assets/uploads/promo/';
		$config['allowed_types']        = 'gif|jpg|jpeg|png';
		$new_name 						= time().'-'.$_FILES["fileimg"]['name'];
		$config['file_name'] 			= $new_name;
		
	    if(!empty($this->input->post('kat') && $this->input->post('nama'))){
	        move_uploaded_file($_FILES['fileimg']['tmp_name'],"./assets/uploads/promo/". $new_name);
	        
			$this->load->library('upload', $config);
			$data = array('upload_data' => $this->upload->data());
			
			$kategori = $this->input->post('kat');
			$file = $this->upload->data('file_name');
			$nama = $this->input->post('nama');
			$desk = $this->input->post('desk');
			$linkaja = $this->input->post('link');
			$std = $this->input->post('tanggal1');
			$stb = $this->input->post('bln1');
			$stt = $this->input->post('thn1');
			$end = $this->input->post('tanggal2');
			$enb = $this->input->post('bln2');
			$ent = $this->input->post('thn2');
			$promo = $this->input->post('promo');
			
			$data = $this->db->query("INSERT INTO `link_list` (`kategori`, `img_name`, `nama`, `linkaja`, `desc`, `tanggal1`, `bulan1`, `tahun1`, `tanggal2`, `bulan2`, `tahun2`, `kodein` )
				VALUES ('$kategori', '$file', '$nama', '$linkaja', '$desk', '$std', '$stb', '$stt', '$end', '$enb', '$ent', '$promo');");
				$q = $this->db->insert_id();
				if($data >= 1){
					$this->session->set_flashdata('data','Data link berhasil disimpan.');
					redirect("/admin/links/");
				}
			
	    }

		$this->mPageTitle = 'Create Links';
		//$this->render('links/create');
	}

	// User Groups CRUD
	public function group()
	{
		$crud = $this->generate_crud('groups');
		$this->mPageTitle = 'User Groups';
		$this->render_crud();
	}

	// Frontend User Reset Password
	public function reset_password($user_id)
	{
		// only top-level users can reset user passwords
		$this->verify_auth(array('webmaster', 'admin'));

		$form = $this->form_builder->create_form();
		if ($form->validate())
		{
			// pass validation
			$data = array('password' => $this->input->post('new_password'));
			
			// [IMPORTANT] override database tables to update Frontend Users instead of Admin Users
			$this->ion_auth_model->tables = array(
				'users'				=> 'users',
				'groups'			=> 'groups',
				'users_groups'		=> 'users_groups',
				'login_attempts'	=> 'login_attempts',
			);

			// proceed to change user password
			if ($this->ion_auth->update($user_id, $data))
			{
				$messages = $this->ion_auth->messages();
				$this->system_message->set_success($messages);
			}
			else
			{
				$errors = $this->ion_auth->errors();
				$this->system_message->set_error($errors);
			}
			refresh();
		}

		$this->load->model('user_model', 'users');
		$target = $this->users->get($user_id);
		$this->mViewData['target'] = $target;

		$this->mViewData['form'] = $form;
		$this->mPageTitle = 'Reset User Password';
		$this->render('user/reset_password');
	}
}
