<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Orders page
 */
class Orders extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		
 
        // load Pagination library
        $this->load->library('pagination');
         
        // load from and url helper optional (in this tutorial)
        $this->load->helper(array(
            'form',
            'url'
        ));
		// Load session
		$this->load->library('session');
        // load database
        $this->load->database();
        // load form validation library
        $this->load->library('form_validation');
		// $this->load->library('phpmailer');
		$this->load->library('form_builder');
		
		// Load model
		$this->load->model('Toped_model');
	}

	public function index(){
	}
	
	public function view(){
		$segment = $this->uri->segment(4);
		$q = $this->uri->segment(5);
		
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		
		if($segment = 'toped'){
			$tes = encrypt_decrypt('decrypt', $q);
			$this->mPageTitle = 'Detail Order Tokopedia';
			$this->render('orders/vtoped');
		}else if($segment = 'web'){
			echo 'ini page view web magento';
		}
	}
	
	public function website(){
		
		$this->mPageTitle = 'Orders Website';
		$this->render('orders/web');
	}
	
	public function clear(){
		$currentURL = current_url();
		$this->session->unset_userdata('search');
		
		redirect($currentURL);
	}
	
	public function tokopedia(){
		
        // load db and model
        $this->load->database();
        $this->load->model('Toped_model');
 
		$this->mPageTitle = 'Orders Tokopedia';
		$this->render('orders/toped');
	}
	
	public function toped(){
		
		$this->mPageTitle = 'Orders Tokopedia';
		$this->render('orders/ped');
	}
	
   public function empList(){
     
     // POST data
     $postData = $this->input->post();

     // Get data
     $data = $this->Toped_model->getToped($postData);

     echo json_encode($data);
  }
}