<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends Admin_Controller {
	private $filename = "import_data"; // Kita tentukan nama filenya
	var $data;

	public function __construct()
	{
		parent::__construct();
        // load Pagination library
        $this->load->library('pagination');
        // load from and url helper optional (in this tutorial)
        $this->load->helper(array(
            'form',
            'url'
        ));
        // load database
        $this->load->database();
        // load form validation library
        $this->load->library('form_validation');
		// $this->load->library('phpmailer');
		$this->load->library('form_builder');
		$this->load->model('ReportProduct');
	}

	// Frontend User CRUD
	public function index(){
		redirect("admin/product/master"); // Redirect ke halaman awal (ke controller siswa fungsi index)
	}

	public function master(){

		$this->mPageTitle = 'Master Data Product';
		$this->render('product/index');
		
	}

	public function hapus_master_product(){
		$this->db->empty_table('sku_product');
		?>
		<script type="text/javascript">
		alert("Data master product berhasil dihapus.");
		window.location.href = "./master";
		</script>
		<?php
		
	}


	public function hapus_bundling(){
		$this->db->empty_table('sku_mapping');
		?>
		<script type="text/javascript">
		alert("Data detail bundling berhasil dihapus.");
		window.location.href = "./bundling";
		</script>
		<?php
		
	}


	public function hapus_barcode(){
		$this->db->empty_table('barcode_mapping');
		?>
		<script type="text/javascript">
		alert("Data barcode berhasil dihapus.");
		window.location.href = "./barcode";
		</script>
		<?php
		
	}

	public function form_bundling(){
		$this->mPageTitle = 'Import Bundling';
		$this->render('product/importbundling');
	}
	

	public function form_barcode(){
		$this->mPageTitle = 'Import Barcode';
		$this->render('product/importbarcode');
	}
	

	public function bundling(){

		$this->mPageTitle = 'Data Product Bundling';
		$this->render('product/bundling');
		
	}

	public function barcode(){
		$segment = $this->uri->segment(4);
		if($segment == 'add'){
			$this->mPageTitle = 'Data Barcode Product';
			$this->render('product/addbarcode');
		}else{
			$this->mPageTitle = 'Data Barcode Product';
			// $this->render('product/barcode');
			$this->render('product/barcode_paging');
		}
	}

	public function export_bundling(){
		$tgl = date("M-Y", strtotime("-1 months"));
		$title="Data-Bundling-".$tgl;
		header("Content-type: application/vnd-ms-excel");
		header("Content-Disposition: attachment; filename=$title.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		?>
			
		<table border="1" cellpadding="8">
			<tr>
				<th>No</th>
				<th>Brand</th>
				<th>Type</th>
				<th>FG Bundling</th>
				<th>FG Satuan</th>
				<th>Detail</th>
				<th>Name</th>
				<th>QTY</th>
			</tr>

			<?php
			// $data['report'] = $this->BreakdownModel->view();
			$data['report'] = $this->ReportProduct->BundlingView();
			$report = $data['report'];
			if( ! empty($report)){ // Jika data pada database tidak sama dengan empty (alias ada datanya)
				$no=1;
				foreach($report as $data){ // Lakukan looping pada variabel siswa dari controller
						echo "<tr>";
						echo "<td>".$no."</td>";
						echo "<td>".$data->Brand."</td>";
						echo "<td>".$data->Type."</td>";
						echo "<td>".$data->FG_Bundling."</td>";
						echo "<td>".$data->FG_Satuan."</td>";
						echo "<td>".$data->Detail."</td>";
						echo "<td>".$data->Name."</td>";
						echo "<td>".$data->QTY."</td>";
						echo "</tr>";
						$no++;
				}
			}else{ // Jika data tidak ada
				echo "<tr><td colspan='8'>Data tidak ada</td></tr>";
			}
			?>
		</table>
		<?php
	}
	
	public function export_barcode(){
		$tgl = date("M-Y", strtotime("-1 months"));
		$title="Data-Barcode-".$tgl;
		header("Content-type: application/vnd-ms-excel");
		header("Content-Disposition: attachment; filename=$title.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		?>
			
		<table border="1" cellpadding="3">
			<tr>
				<th>No</th>
				<th>FG code</th>
				<th>Barcode</th>
			</tr>

			<?php
			// $data['report'] = $this->BreakdownModel->view();
			$data['report'] = $this->ReportProduct->BarcodeView();
			$report = $data['report'];
			if( ! empty($report)){ // Jika data pada database tidak sama dengan empty (alias ada datanya)
				$no=1;
				foreach($report as $data){ // Lakukan looping pada variabel siswa dari controller
						echo "<tr>";
						echo "<td>".$no."</td>";
						echo "<td>".$data->fgcode."</td>";
						echo "<td>".$data->barcode."</td>";
						echo "</tr>";
						$no++;
				}
			}else{ // Jika data tidak ada
				echo "<tr><td colspan='3'>Data tidak ada</td></tr>";
			}
			?>
		</table>
		<?php
	}
	
	public function import(){
		$this->mPageTitle = 'Import Master Data Product';
		$this->render('product/import_new');
	}
	/* 
	public function upload(){
		// Load plugin PHPExcel nya
		include APPPATH.'third_party/PHPExcel/PHPExcel.php';
		
		$excelreader = new PHPExcel_Reader_Excel2007();
		$loadexcel = $excelreader->load('excel/upload.xlsx'); // Load file yang telah diupload ke folder excel
		$sheet = $loadexcel->getActiveSheet()->toArray(null, true, true ,true);
		
		// Buat sebuah variabel array untuk menampung array data yg akan kita insert ke database
		$data = [];
		
		$numrow = 1;
		foreach($sheet as $row){
			// Cek $numrow apakah lebih dari 1
			// Artinya karena baris pertama adalah nama-nama kolom
			// Jadi dilewat saja, tidak usah diimport
			if($numrow > 1){
				// Kita push (add) array data ke variabel data
				array_push($data, [
					'Brand_' => $row['B'],
					'Segmen' => $row['C'],
					'Type' => $row['D'],
					'FG' => $row['E'],
					'ProdName' => $row['F'],
					'UOM' => $row['G'],
					'NewHPP' => $row['H'],
					'NewMT' => $row['I'],
					'up30' => $row['J'],
					'Roundup30' => $row['K'],
					'up35' => $row['L'],
					'Roundup35' => $row['M'],
					'Akulaku' => $row['N'],
					'RoundupAkulaku' => $row['O'],
					'Zilingo' => $row['P'],
					'RoundupZilingo' => $row['Q'],
					'MTup5' => $row['R'],
					'Roundup5' => $row['S'],
					'MTup7' => $row['T'],
					'Roundup7' => $row['U'],
				]);
			}
			
			$numrow++; // Tambah 1 setiap kali looping
		}

		// Panggil fungsi insert_multiple yg telah kita buat sebelumnya di model
		$this->ReportProduct->insert_multiple($data);
		
		redirect("admin/product"); // Redirect ke halaman awal (ke controller siswa fungsi index)
	} 
	*/
	
	public function upload(){
		$filename = "DataProduct";
		// Load plugin PHPExcel nya
		include APPPATH.'third_party/PHPExcel/PHPExcel.php';
		
		$excelreader = new PHPExcel_Reader_Excel2007();
		$loadexcel = $excelreader->load('excel/'.$filename.'.xlsx'); // Load file yang telah diupload ke folder excel
		$sheet = $loadexcel->getActiveSheet()->toArray(null, true, true ,true);
		
		// Buat sebuah variabel array untuk menampung array data yg akan kita insert ke database
		$data = [];
		
		$numrow = 1;
		foreach($sheet as $row){
			// Cek $numrow apakah lebih dari 1
			// Artinya karena baris pertama adalah nama-nama kolom
			// Jadi dilewat saja, tidak usah diimport
			if($numrow > 1){
				// Kita push (add) array data ke variabel data
				array_push($data, [
					
					'Category' => $row['A'],
					'Brand_' => $row['B'],
					'FG' => $row['C'],
					'ProdName' => $row['D'],
					'Lazada' => $row['E'],
					'Lazada_SB' => $row['F'],
					'Lazada_KPWMI' => $row['G'],
					'Shopee' => $row['H'],
					'Shopee_KPWMI' => $row['I'],
					'Tokopedia' => $row['J'],
					'Tokopedia_KPWMI' => $row['K'],
					'Duha' => $row['L'],
					'Ruparupa' => $row['M'],
					'Zilingo' => $row['N'],
					'iLotte' => $row['O'],
					'Akulaku' => $row['P'],
					'Mataharimall' => $row['Q'],
					'Jakmall' => $row['R'],
					'Elevenia' => $row['S'],
					'Blanja' => $row['T'],
					'Bukalapak' => $row['U'],
					'Bukalapak_KPWMI' => $row['V'],
					'GoApotik' => $row['W'],
					'Alfacart' => $row['X'],
					'Blibli' => $row['Y'],
					'Orami' => $row['Z'],
					'JDID' => $row['AA'],
					'ShopeeB2B' => $row['AB'],
					'AkuGrosir' => $row['AC'],
					'Tororo' => $row['AD'],
					'Farmaku' => $row['AE'],
					'Gogobli' => $row['AF'],
					'KUDO' => $row['AG'],
					'Status' => $row['AH'],
					'Type' => $row['AI'],
					'UOM' => $row['AJ'],
					'NewHPP' => $row['AK'],
					'NewMT' => $row['AL'],
					'MTup5' => $row['AM'],
					'Roundup5' => $row['AN'],
					'MTup7' => $row['AO'],
					'Roundup7' => $row['AP'],
				]);
			}
			
			$numrow++; // Tambah 1 setiap kali looping
		}

		// Panggil fungsi insert_multiple yg telah kita buat sebelumnya di model
		$this->ReportProduct->insert_multiple($data);
		
		redirect("admin/product/master"); // Redirect ke halaman awal (ke controller siswa fungsi index)
	}
	
	// Create Frontend Product
/* 	public function create(){
		$config['upload_path']          = './assets/uploads/promo/';
		$config['allowed_types']        = 'gif|jpg|jpeg|png';
		$new_name 						= time().'-'.$_FILES["fileimg"]['name'];
		$config['file_name'] 			= $new_name;
		
	    if(!empty($this->input->post('kat') && $this->input->post('nama'))){
	        move_uploaded_file($_FILES['fileimg']['tmp_name'],"./assets/uploads/promo/". $new_name);
	        
			$this->load->library('upload', $config);
			$data = array('upload_data' => $this->upload->data());
			
			$kategori = $this->input->post('kat');
			$file = $this->upload->data('file_name');
			$nama = $this->input->post('nama');
			$linkaja = $this->input->post('link');
			$std = $this->input->post('tanggal1');
			$stb = $this->input->post('bln1');
			$stt = $this->input->post('thn1');
			$end = $this->input->post('tanggal2');
			$enb = $this->input->post('bln2');
			$ent = $this->input->post('thn2');
			$promo = $this->input->post('promo');
			
			$data = $this->db->query("INSERT INTO `link_list` (`kategori`, `img_name`, `nama`, `linkaja`, `tanggal1`, `bulan1`, `tahun1`, `tanggal2`, `bulan2`, `tahun2`, `kodein` )
				VALUES ('$kategori', '$file', '$nama', '$linkaja', '$std', '$stb', '$stt', '$end', '$enb', '$ent', '$promo');");
				$q = $this->db->insert_id();
				if($data >= 1){
					$this->session->set_flashdata('data','Data link berhasil disimpan.');
					redirect("/admin/links/");
				}
			
	    }

		$this->mPageTitle = 'Create Links';
		//$this->render('links/create');
	}
 */
}
