<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends Admin_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->library('form_builder');
		$this->load->model('ReportUsers');
	}

	// Frontend User CRUD
	public function index(){
		$this->mPageTitle = 'List Users';
		$this->render('users/index');
	}
	
	public function import(){
		$this->mPageTitle = 'Import Users';
		$this->render('users/import');
	}
	
	public function update(){
		$this->mPageTitle = 'Update Users';
		$this->render('users/update');
	}
	
	public function delete($id_jobs = NULL){
		function encrypt_decrypt($action, $string) {
			$output = false;

			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';

			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);

			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			}
			else if( $action == 'decrypt' ){
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}

			return $output;
		}
		
		$id = encrypt_decrypt('decrypt', $this->uri->segment('4'));
		$hapus = $this->db->query("DELETE FROM user WHERE id_user=$id");
		$hapusdua = $this->db->query("DELETE FROM profile WHERE id_user=$id");
		if($hapusdua >= 1){
			$this->session->set_flashdata('data','Data User berhasil dihapus.');
			redirect("/admin/users/");
		}
	}
	
	
	public function upload(){
		// Load plugin PHPExcel nya
		include APPPATH.'third_party/PHPExcel/PHPExcel.php';
		
		$excelreader = new PHPExcel_Reader_Excel2007();
		$loadexcel = $excelreader->load('excel/upload.xlsx'); // Load file yang telah diupload ke folder excel
		$sheet = $loadexcel->getActiveSheet()->toArray(null, true, true ,true);
		
		// Buat sebuah variabel array untuk menampung array data yg akan kita insert ke database
		$data = [];
		
		$numrow = 1;
		foreach($sheet as $row){
			// Cek $numrow apakah lebih dari 1
			// Artinya karena baris pertama adalah nama-nama kolom
			// Jadi dilewat saja, tidak usah diimport
			if($numrow > 1){
				// Kita push (add) array data ke variabel data
				array_push($data, [
					'cat_user' => $row['L'],
					'name_user' => $row['C'],
					'phone_user' => $row['I'],
					'mail_user' => $row['K'],
					'tl_user' => $row['D'],
					'ttl_user' => $row['E'],
					'gender' => $row['F'],
					'address_user' => $row['G'],
					'toko_user' => $row['H'],
					'wa_user' => $row['J'],
					'closing_user' => $row['B'],
				]);
			}
			
			$numrow++; // Tambah 1 setiap kali looping
		}

		// Panggil fungsi insert_multiple yg telah kita buat sebelumnya di model
		$this->ReportUsers->insert_multiple($data);
		
		redirect("admin/users"); // Redirect ke halaman awal (ke controller siswa fungsi index)
	}
	
}