<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ReportProduct extends CI_Model {
	
	// Fungsi untuk melakukan proses upload file
	public function upload_file($filename){
		$this->load->library('upload'); // Load librari upload
		
		$config['upload_path'] = './excel/';
		$config['allowed_types'] = 'xlsx';
		// $config['max_size']	= '2048';
		$config['overwrite'] = true;
		$config['file_name'] = $filename;
	
		$this->upload->initialize($config); // Load konfigurasi uploadnya
		if($this->upload->do_upload('file')){ // Lakukan upload dan Cek jika proses upload berhasil
			// Jika berhasil :
			$return = array('result' => 'success', 'file' => $this->upload->data(), 'error' => '');
			return $return;
		}else{
			// Jika gagal :
			$return = array('result' => 'failed', 'file' => '', 'error' => $this->upload->display_errors());
			return $return;
		}
	}
	
	// Fungsi untuk melakukan proses upload file
	public function upload_bundling($filename){
		$this->load->library('upload'); // Load librari upload
		
		$config['upload_path'] = './excel/bundling/';
		$config['allowed_types'] = 'xlsx';
		// $config['max_size']	= '2048';
		$config['overwrite'] = true;
		$config['file_name'] = $filename;
	
		$this->upload->initialize($config); // Load konfigurasi uploadnya
		if($this->upload->do_upload('file')){ // Lakukan upload dan Cek jika proses upload berhasil
			// Jika berhasil :
			$return = array('result' => 'success', 'file' => $this->upload->data(), 'error' => '');
			return $return;
		}else{
			// Jika gagal :
			$return = array('result' => 'failed', 'file' => '', 'error' => $this->upload->display_errors());
			return $return;
		}
	}
  
	// Fungsi untuk melakukan proses upload file
	public function upload_barcode($filename){
		$this->load->library('upload'); // Load librari upload
		
		$config['upload_path'] = './excel/barcode/';
		$config['allowed_types'] = 'xlsx';
		// $config['max_size']	= '2048';
		$config['overwrite'] = true;
		$config['file_name'] = $filename;
	
		$this->upload->initialize($config); // Load konfigurasi uploadnya
		if($this->upload->do_upload('file')){ // Lakukan upload dan Cek jika proses upload berhasil
			// Jika berhasil :
			$return = array('result' => 'success', 'file' => $this->upload->data(), 'error' => '');
			return $return;
		}else{
			// Jika gagal :
			$return = array('result' => 'failed', 'file' => '', 'error' => $this->upload->display_errors());
			return $return;
		}
	}
  
	public function BundlingView(){
		return $this->db->get('sku_mapping')->result(); // Tampilkan semua data yang ada di tabel siswa
	}
	
  
	public function BarcodeView(){
		return $this->db->get('barcode_mapping')->result(); // Tampilkan semua data yang ada di tabel siswa
	}
	
	// Buat sebuah fungsi untuk melakukan insert lebih dari 1 data
	public function insert_bundling($data){
		// $this->db->insert_batch('july', $data);
		$this->db->insert_batch('sku_mapping', $data);
	}
	
	
	// Buat sebuah fungsi untuk melakukan insert lebih dari 1 data
	public function insert_barcode($data){
		$this->db->insert_batch('barcode_mapping', $data);
	}
	
	// Buat sebua
	
	// Buat sebuah fungsi untuk melakukan insert lebih dari 1 data
	public function insert_multiple($data){
		// $this->db->insert_batch('master_product', $data);
		$this->db->insert_batch('sku_product', $data);
	}
	
	// Buat sebuah fungsi untuk melakukan insert lebih dari 1 data
	public function insert_movement($data){
		$this->db->insert_batch('movement', $data);
	}
	
	// Buat sebuah fungsi untuk melakukan insert lebih dari 1 data
	public function insert_productevent($data){
		$this->db->insert_batch('product_event', $data);
	}
	
    public function get_total($brand="", $search_product="") {
		$this->db->select('count(*) as allcount');
		// $this->db->from('master_product'); //tabel master_product di ganti dengan tabel sku_product
		$this->db->from('sku_product');
		
		if($brand != '' AND $search_product != ''){
			$this->db->like('Brand_', $brand);
			$this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
		}else{
			if($brand != '' AND $search_product == ''){
			  $this->db->like('Brand_', $brand);
			}else if($brand == '' AND $search_product != ''){
			  $this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
			}	
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
		
		// return $this->db->count_all("order_tokopedia");
    }
	
    public function get_products($limit, $start, $brand="", $search_product="") {
		if($brand != '' AND $search_product != ''){
			$this->db->like('Brand_', $brand);
			$this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
		}else{
			if($brand != '' AND $search_product == ''){
			  $this->db->like('Brand_', $brand);
			}else if($brand == '' AND $search_product != ''){
			  $this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
			}			
		}
        $this->db->limit($limit, $start);
        // $query = $this->db->get("master_product"); //tabel master_product di ganti dengan tabel sku_product
        $query = $this->db->get("sku_product"); 

        return $query->result();
    }
	
	
    public function get_total_inventory($brand="", $search_product="") {
		$this->db->select('count(*) as allcount');
		// $this->db->from('master_product');
		$this->db->from('sku_product');
		$this->db->where('Type', 'Single'); 
		
		if($brand != '' AND $search_product != ''){
			$this->db->like('Brand_', $brand);
			$this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
		}else{
			if($brand != '' AND $search_product == ''){
			  $this->db->like('Brand_', $brand);
			}else if($brand == '' AND $search_product != ''){
			  $this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
			  // $this->db->or_like('ProdName', $search_product);
			}	
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
		
		// return $this->db->count_all("order_tokopedia");
    }
    public function get_products_inventory($limit, $start, $brand="", $search_product="") {
    // public function get_products($limit, $start, $search_product="") {
		if($brand != '' AND $search_product != ''){
			$this->db->like('Brand_', $brand);
			$this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
		}else{
			if($brand != '' AND $search_product == ''){
			  $this->db->like('Brand_', $brand);
			}else if($brand == '' AND $search_product != ''){
			  $this->db->like('FG', $search_product, 'both', 'ProdName', $search_product, 'both');
			  // $this->db->or_like('ProdName', $search_product);
			}			
		}
        /* $this->db->limit($limit, $start);
		$this->db->where('Type', 'Single'); 
        $query = $this->db->get("master_product"); */
		// $query = $this->db->get_where('master_product', array('Type' => 'Single'), $limit, $start);
		$query = $this->db->get_where('sku_product', array('Type' => 'Single'), $limit, $start);
        return $query->result();
    }
	
	
    public function get_bdl($limit, $start, $search_bdl="") {
		if($search_bdl != ''){
			$this->db->like('FG_Bundling', $search_bdl, 'both', 'FG_Satuan', $search_bdl, 'both');
		}
        $this->db->limit($limit, $start);
        $query = $this->db->get("sku_mapping");
        return $query->result();
    }
	
    public function get_total_bdl($search_bdl="") {
		$this->db->select('count(*) as allcount');
		$this->db->from('sku_mapping');
		
		if($search_bdl != ''){
			$this->db->like('FG_Bundling', $search_bdl, 'both', 'FG_Satuan', $search_bdl, 'both');
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
    }
	
	
    public function get_return($limit, $start, $search_return="") {
		if($search_return != ''){
			// $this->db->like('no_po', $search_return, 'both', 'no_do', $search_return, 'none');
			$this->db->like('no_do', $search_return, 'both');
			// $this->db->like('no_po', $search_return, 'both', 'no_do', $search_return);
		}
		$query = $this->db->get_where('inventory', array('type' => 'RE'), $limit, $start);
        return $query->result();
    }
	
    public function get_total_return($search_return="") {
		$this->db->select('count(*) as allcount');
		$this->db->from('inventory');
		$this->db->where('type', 'RE'); 
		
		if($search_return != ''){
			// $this->db->like('no_po', $search_return, 'both', 'no_do', $search_return, 'none');
			$this->db->like('no_do', $search_return, 'both');
			// $this->db->like('no_po', $search_return, 'both', 'no_do', $search_return, 'no_do', $search_return);
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
    }
	
    public function get_po($limit, $start, $search_in="") {
    // public function get_products($limit, $start, $search_product="") {
		if($search_in != ''){
			$this->db->like('no_po', $search_in, 'both', 'no_do', $search_in, 'both');
		}
        /* $this->db->limit($limit, $start);
		$this->db->where('Type', 'Single'); 
        $query = $this->db->get("master_product"); */
		$query = $this->db->get_where('inventory', array('type' => 'PO'), $limit, $start);
        return $query->result();
    }
	
    public function get_total_po($search_in="") {
		$this->db->select('count(*) as allcount');
		$this->db->from('inventory');
		$this->db->where('type', 'PO'); 
		
		if($search_in != ''){
			$this->db->like('no_po', $search_in, 'both', 'no_do', $search_in, 'both');
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
		
		// return $this->db->count_all("order_tokopedia");
    }
	
	/* 
    public function get_do($limit, $start, $search_product="") {
    // public function get_products($limit, $start, $search_product="") {
		if($search_product != ''){
			$this->db->like('no_po', $search_product, 'no_do', $search_product);
		}
        /* $this->db->limit($limit, $start);
		$this->db->where('Type', 'Single'); 
        $query = $this->db->get("master_product"); *
		$query = $this->db->get_where('inventory', array('type' => 'DO'), $limit, $start);
        return $query->result();
    }
	
    public function get_total_do($search_product="") {
		$this->db->select('count(*) as allcount');
		$this->db->from('inventory');
		$this->db->where('type', 'DO'); 
		
		if($search_product != ''){
			$this->db->like('no_po', $search_product, 'no_do', $search_product);
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
		
		// return $this->db->count_all("order_tokopedia");
    } */
	
    public function get_out($limit, $start, $search_out="") {
    // public function get_products($limit, $start, $search_product="") {
		if($search_out != ''){
			$this->db->like('no_do', $search_out, 'both');
		}
        /* $this->db->limit($limit, $start);
		$this->db->where('Type', 'Single'); 
        $query = $this->db->get("master_product"); */
		$query = $this->db->get_where('inventory', array('type' => 'DO'), $limit, $start);
        return $query->result();
    }
	
    public function get_total_out($search_out="") {
		$this->db->select('count(*) as allcount');
		$this->db->from('inventory');
		$this->db->where('type', 'DO'); 
		
		if($search_out != ''){
			$this->db->like('no_do', $search_out, 'both');
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
		
		// return $this->db->count_all("order_tokopedia");
    }
	
	
	
	public function tampil_data(){ 
       // return $this->db->get('master_product');
       return $this->db->get('sku_product');
    }
	
    public function GetRow($keyword) {        
        $this->db->order_by('id', 'DESC');
        $this->db->like("FG", $keyword);
        // return $this->db->get('master_product')->result_array();
        return $this->db->get('sku_product')->result_array();
    }
	
	public function cari($fg){
        // $query= $this->db->get_where('master_product',array('FG'=>$fg));
        $query= $this->db->get_where('sku_product',array('FG'=>$fg));
        return $query;
		
		// $this->data['noStiker'] = $id;
		
		// $query = $this->db->query("select * from master_product where FG = '$fg'");
		// $rows = $query->result_array();
		// echo json_encode($rows);
    }
	
	
    public function get_totalbarcode($search_barcode="") {
		$this->db->select('count(*) as allcount');
		$this->db->from('barcode_mapping');
        if($search_barcode != ''){
		  $this->db->like('fgcode', $search_barcode, 'both');
		  $this->db->or_like('barcode', $search_barcode, 'both');
		}
		$query = $this->db->get();
		$result = $query->result_array();
	 
		return $result[0]['allcount'];
		
		// return $this->db->count_all("order_tokopedia");
    }
	
    public function get_barcodes($limit, $start, $search_barcode="") {
		if($search_barcode != ''){
		  $this->db->like('fgcode', $search_barcode, 'both');
		  $this->db->or_like('barcode', $search_barcode, 'both');
		}
        $this->db->limit($limit, $start);
        $query = $this->db->get("barcode_mapping");

        return $query->result();
    }
	
}
	