<!-- Page specific script -->
<script>

  document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
		plugins: [ 'interaction', 'dayGrid' ],
		defaultDate: '2019-12-05',
		editable: true,
		eventLimit: true, // allow "more" link when too many events
		events: [
			
			url: '<?= base_url(); ?>admin/agenda/agen',
			/* {
			  title: 'All Day Event',
			  start: '2019-12-01'
			},
			{
			  title: 'Long Event',
			  start: '2019-12-07',
			  end: '2019-12-10'
			},
			{
			  groupId: 999,
			  title: 'Repeating Event',
			  start: '2019-12-09T16:00:00'
			},
			{
			  groupId: 999,
			  title: 'Repeating Event',
			  start: '2019-12-16T16:00:00',
			  backgroundColor: '#f39c12', //yellow
			  borderColor    : '#f39c12' //yellow
			},
			{
			  title: 'Conference',
			  start: '2019-12-11',
			  end: '2019-12-13'
			},
			{
			  title: 'Meeting',
			  start: '2019-12-12T00:00:01',
			  end: '2019-12-12T23:59:59',
			  url: 'http://google.com/',
			  backgroundColor: '#f56954', //red
			  borderColor    : '#f56954' //red
			},
			{
			  title: 'Lunch',
			  start: '2019-12-12T12:00:00'
			},
			{
			  title: 'Meeting',
			  start: '2019-12-12T14:30:00'
			},
			{
			  title: 'Happy Hour',
			  start: '2019-12-12T17:30:00'
			},
			{
			  title: 'Dinner',
			  start: '2019-12-12T20:00:00'
			},
			{
			  title: 'Birthday Party',
			  start: '2019-12-13T07:00:00'
			},
			{
			  title: 'Click for Google',
			  url: 'http://google.com/',
			  start: '2019-12-28'
			} */
		],
		eventClick: function(event) {
			if (event.url) {
				window.open(event.url, "_blank");
				return false;
			}
		}
    });
	$('.fc-toolbar').remove();
	$('.fc-view-container').remove();
    calendar.render();
  });

</script>
<style>
  #agenda {
    max-width: 900px;
    margin: 0 auto;
  }

</style>
<div class="row">
	<div class="col-md-3">
	  <div class="box box-solid">
		<div class="box-header with-border">
		  <h3 class="box-title">Create Event</h3>
		</div>
		<div class="box-body">
		  <div class="btn-group" style="width: 100%; margin-bottom: 10px;">
			<!--<button type="button" id="color-chooser-btn" class="btn btn-info btn-block dropdown-toggle" data-toggle="dropdown">Color <span class="caret"></span></button>-->
			<ul class="fc-color-picker" id="color-chooser">
			  <li><a class="text-aqua" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-blue" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-light-blue" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-teal" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-yellow" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-orange" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-green" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-lime" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-red" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-purple" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-fuchsia" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-muted" href="#"><i class="fa fa-square"></i></a></li>
			  <li><a class="text-navy" href="#"><i class="fa fa-square"></i></a></li>
			</ul>
		  </div>
		  <!-- /btn-group -->
		  <div class="input-group">
			<input id="new-event" type="text" class="form-control" placeholder="Event Title">
			<input id="new-event" type="text" class="form-control" placeholder="Start">
			<input id="new-event" type="text" class="form-control" placeholder="End">
			
			<div class="input-group-btn">
			  <button id="add-new-event" type="button" class="btn btn-primary btn-flat">Add</button>
			</div>
			<!-- /btn-group -->
		  </div>
		  <!-- /input-group -->
		</div>
	  </div>
	</div>
	<!-- /.col -->
	<div class="col-md-9">
	  <div class="box box-primary">
		<div class="box-body no-padding">
			
		  <!-- THE CALENDAR -->
		  <div id="calendar"></div>
		</div>
		<!-- /.box-body -->
	  </div>
	  <!-- /. box -->
	</div>
	<!-- /.col -->
  </div>
  <!-- /.row -->