<!-- Page specific script -->
<script type="text/javascript">
	$(function () {
		$('#datetimepicker1').datetimepicker({
			// dateFormat: 'dd-mm-yy',
			format:'yyyy-mm-dd HH:mm:ss',
		});
		$('#datetimepicker2').datetimepicker({
			// dateFormat: 'dd-mm-yy',
			format:'yyyy-mm-dd HH:mm:ss',
		});
	});
	
	document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
		// plugins: [ 'interaction', 'dayGrid' ],
		plugins: [ 'interaction', 'dayGrid', 'timeGrid', 'list', 'rrule' ],
		header: {
			left: 'prev,next today',
			center: 'title',
			right: 'dayGridMonth,timeGridWeek,listMonth'
		},
		// defaultDate: '2019-12-05',
		defaultDate: '<?php echo date("Y-m-d");?>',
		editable: true,
		eventLimit: true, // allow "more" link when too many events
		events: "<?= base_url(); ?>admin/agenda/agen"
    });
	$('.fc-toolbar').remove();
	$('.fc-view-container').remove();
    calendar.render();
  });

</script>
<style>
#agenda {
    max-width: 900px;
    margin: 0 auto;
}
  
select option {
  margin: 40px;
  background: rgba(0, 0, 0, 0.3);
  color: #fff;
  text-shadow: 0 1px 0 rgba(0, 0, 0, 0.4);
}

select option[value="#39cccc"] {
  background: #39cccc;
}

select option[value="#dd4b39"] {
  background: #dd4b39;
}

select option[value="#ff851b"] {
  background: #ff851b;
}

select option[value="#3c8dbc"] {
  background: #3c8dbc;
}

select option[value="#f012be"] {
  background: #f012be;
}

select option[value="#00a65a"] {
  background: #00a65a;
}
</style>

<div class="row">
	<div class="col-xs-12">
		<?php if($this->session->flashdata('data') != ''){ ?>
		<div class="col-md-12">
			<div class="alert alert-info alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
				<h4><i class="icon fa fa-check"></i> Success!</h4>
				<?php echo $this->session->flashdata('data');?>
			</div>
		</div>
		<?php
		}
		?>
	</div>
</div>
<div class="row">
	<div class="col-md-3">
	  <div class="box box-solid">
		<div class="box-header with-border">
		  <h3 class="box-title">Create Agenda</h3>
		</div>
		<div class="box-body">
			<form class="form-horizontal" action="<?= base_url(); ?>admin/agenda/save" method="POST">
				<div class="control-group">					
					<select class="form-control" name="mp">
						<option value="">Please choose</option><?php
							$query = $this->db->query("SELECT * FROM channel");
							foreach ($query->result_array() as $data){
						?>
						<option value="<?php echo $data['value'];?>"><?php echo $data['name'];?></option>
						<?php
							}
						?>
					</select>
					<!--select class="form-control" name="mp">
						<option value="">Please choose</option>
						<option value="#39cccc">Akulaku</option>
						<option value="#dd4b39">Bukalapak</option>
						<option value="#3c8dbc">Elevenia</option>
						<option value="#f012be">Lazada</option>
						<option value="#ff851b">Shopee</option>
						<option value="#00a65a">Tokopedia</option>
					</select-->
				</div><br/>
				<div class="control-group">
					<input name="title" type="text" class="form-control" placeholder="Event Title">
				</div><br/>
				<div class="control-group">
					<textarea type="text" class="form-control" name="description" placeholder="Description ..."></textarea>
				</div><br/>
				<div class='input-group date' id='datetimepicker1'>
					<input type='text' name="start_date" class="form-control" placeholder="Start Date" />
					<span class="input-group-addon">
						<span class="glyphicon glyphicon-calendar"></span>
					</span>
				</div><br/>
				<div class='input-group date' id='datetimepicker2'>
					<input type='text' name="end_date" class="form-control" placeholder="End Date" />
					<span class="input-group-addon">
						<span class="glyphicon glyphicon-calendar"></span>
					</span>
				</div><br/>
				<div class="box-footer">
					<input type="submit" class="btn btn-primary" name="preview" value="Create">
				</div>
			</form>
		</div>
	  </div>
	</div>
	<!-- /.col -->
	<div class="col-md-9">
	  <div class="box box-primary">
		<div class="box-body no-padding">
			
		  <!-- THE CALENDAR -->
		  <div id="calendar"></div>
		</div>
		<!-- /.box-body -->
	  </div>
	  <!-- /. box -->
	</div>
	<!-- /.col -->
  </div>
  <!-- /.row -->