<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bundling extends CI_Controller {
	private $filename = "import_data"; // Kita tentukan nama filenya
	
	public function __construct(){
		parent::__construct();
		
		$this->load->model('BundlingModel');
		$this->load->model('ReportModel');
	}
	
	public function index(){
		$data['bundling'] = $this->BundlingModel->view();
		$this->load->view('bundling/view', $data);
	}
	
	public function form(){
		$data = array(); // Buat variabel $data sebagai array
		
		if(isset($_POST['preview'])){ // Jika user menekan tombol Preview pada form
			// lakukan upload file dengan memanggil function upload yang ada di SiswaModel.php
			$upload = $this->BundlingModel->upload_file($this->filename);
			
			if($upload['result'] == "success"){ // Jika proses upload sukses
				// Load plugin PHPExcel nya
				include APPPATH.'third_party/PHPExcel/PHPExcel.php';
				
				$excelreader = new PHPExcel_Reader_Excel2007();
				$loadexcel = $excelreader->load('excel/'.$this->filename.'.xlsx'); // Load file yang tadi diupload ke folder excel
				$sheet = $loadexcel->getActiveSheet()->toArray(null, true, true ,true);
				
				// Masukan variabel $sheet ke dalam array data yang nantinya akan di kirim ke file form.php
				// Variabel $sheet tersebut berisi data-data yang sudah diinput di dalam excel yang sudha di upload sebelumnya
				$data['sheet'] = $sheet; 
			}else{ // Jika proses upload gagal
				$data['upload_error'] = $upload['error']; // Ambil pesan error uploadnya untuk dikirim ke file form dan ditampilkan
			}
		}
		
		$this->load->view('bundling/import', $data);
	}
	
	public function export(){
		$title="Kodon";
		header("Content-type: application/vnd-ms-excel"); 
		// header("Content-Type: text/csv");
		// header("Content-Type: text/plain");	
		header("Content-Disposition: attachment; filename=$title.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		?>
			
		<table border="1" cellpadding="8">
			<tr>
				<th>No</th>
				<th>Type</th>
				<th>FG Bundling</th>
				<th>FG Satuan</th>
				<th>Bundling Name</th>
				<th>Item Name</th>
				<th>Brand</th>
				<th>Qty Item</th>
			</tr>

			<?php
			$data['report'] = $this->ReportModel->kodon();
			$report = $data['report'];
			if( ! empty($report)){ // Jika data pada database tidak sama dengan empty (alias ada datanya)
				$no=1;
				foreach($report as $data){ // Lakukan looping pada variabel siswa dari controller
					$sku_bundling=$data->FG;
					// $query=$this->db->query("SELECT COUNT(*) AS jumlah FROM sku_mapping WHERE FG_Bundling='$sku_bundling'");
					$query=$this->db->query("SELECT * FROM sku_mapping WHERE FG_Bundling='$sku_bundling'");
					$detail = $query->num_rows();
					// print_r($detail);
					// exit;
					if($detail == 0){
						echo "<tr>";
						echo "<td>".$no."</td>";
						echo "<td>Single</td>";
						echo "<td>".$data->FG."</td>";
						echo "<td></td>";
						echo "<td></td>";
						echo "<td></td>";
						echo "<td></td>";
						echo "<td></td>";
						echo "</tr>";
						$no++;
					}else{
						$nomor = $no;
						$seller_sku = $data->FG;
						// $qdetail=$this->db->query("SELECT * FROM sku_mapping WHERE FG_Bundling='$sku_bundling'");
						// $pecah = $qdetail->result_array();
						// print_r($pecah);
						// exit;
						foreach($query->result_array() as $pecah){
							$type=$pecah['Type'];
							if($type == 'Bundling'){
								echo "<tr>";
								echo "<td>".$no."</td>";
								echo "<td>".$type."</td>";
								echo "<td>".$seller_sku."</td>";
								echo "<td>".$pecah['FG_Satuan']."</td>";
								echo "<td>".$pecah['Detail']."</td>";
								echo "<td>".$pecah['Name']."</td>";
								echo "<td>".$pecah['Brand']."</td>";
								echo "<td>".$pecah['QTY']."</td>";
								echo "</tr>";
								$no++;
							}elseif($type == 'Multipack'){
								echo "<tr>";
								echo "<td>".$no."</td>";
								echo "<td>".$type."</td>";
								echo "<td>".$seller_sku."</td>";
								echo "<td>".$pecah['FG_Satuan']."</td>";
								echo "<td>".$pecah['Detail']."</td>";
								echo "<td>".$pecah['Name']."</td>";
								echo "<td>".$pecah['Brand']."</td>";
								echo "<td>".$pecah['QTY']."</td>";
								echo "</tr>";
								$no++;
							}
						}
					}
				}
			}else{ // Jika data tidak ada
				echo "<tr><td colspan='8'>Data tidak ada</td></tr>";
			}
			?>
		</table>
		<?php
	}
	
	
	public function import(){
		// Load plugin PHPExcel nya
		include APPPATH.'third_party/PHPExcel/PHPExcel.php';
		
		$excelreader = new PHPExcel_Reader_Excel2007();
		$loadexcel = $excelreader->load('excel/'.$this->filename.'.xlsx'); // Load file yang telah diupload ke folder excel
		$sheet = $loadexcel->getActiveSheet()->toArray(null, true, true ,true);
		
		// Buat sebuah variabel array untuk menampung array data yg akan kita insert ke database
		$data = [];
		
		$numrow = 1;
		foreach($sheet as $row){
			// Cek $numrow apakah lebih dari 1
			// Artinya karena baris pertama adalah nama-nama kolom
			// Jadi dilewat saja, tidak usah diimport
			if($numrow > 1){
				// Kita push (add) array data ke variabel data
				array_push($data, [
					'Brand' => $row['B'],
					'Type' => $row['C'],
					'FG_Bundling' => $row['D'],
					'FG_Satuan' => $row['E'],
					'Detail' => $row['F'],
					'Name' => $row['G'],
					'QTY' => $row['H'],
				]);
			}
			
			$numrow++; // Tambah 1 setiap kali looping
		}

		// Panggil fungsi insert_multiple yg telah kita buat sebelumnya di model
		$this->BundlingModel->insert_multiple($data);
		
		redirect("Bundling"); // Redirect ke halaman awal (ke controller siswa fungsi index)
	}
}
